------------------------------------------------------------------------------
--	FILE:	 LargestEarth.Lua
--  Convertion and upscaling of Civ IV Genghis Kai's GEM
--  Made for Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 230
local g_iH = 116
local g_iFlags = {}
local g_continentsFrac = nil

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = true,
		WrapY = false,
	};      
end


-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	-- Everything has been moved to the modded AssignStartingPlots in the "override" folder, search for "YnAMP" string in that file
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)
	
	-- Handle Nile delta flow direction (North)
	for x = 38, 41 do
		for y = 58, 62 do
			local plot = Map.GetPlot(x,y)
			if plot then
				MakeRiverFlowToNorth(plot)			
			end
		end
	end
	
	-- Handle source of the Nile flow direction	
	for x = 40, 41 do
		for y = 36, 38 do
			local plot = Map.GetPlot(x,y)
			if plot then
				MakeRiverFlowToNorth(plot)			
			end
		end
	end
end

function GetNaturalWonders()
	local NaturalWonders = {}
	---[[
	NaturalWonders[GameInfo.Features["FEATURE_BARRIER_REEF"].Index] 	 = { X = 134, Y = 28}	-- 2 plots, coast, 1st plot is SOUTHEAST	
	NaturalWonders[GameInfo.Features["FEATURE_CLIFFS_DOVER"].Index] 	 = { X = 15, Y = 89}	-- 2 plots, hills on coast, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_CRATER_LAKE"].Index] 		 = { X = 176, Y = 80}	
	NaturalWonders[GameInfo.Features["FEATURE_DEAD_SEA"].Index] 		 = { X = 47, Y = 62}	-- 2 plots, flat desert surrounded by desert, 1st plot is SOUTHWEST	
	NaturalWonders[GameInfo.Features["FEATURE_EVEREST"].Index] 			 = { X = 87, Y = 67}	-- 3 plots, mountains, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_GALAPAGOS"].Index] 		 = { X = 192, Y = 44}	-- 2 plots, coast, surrounded by coast, 1st plot is SOUTHWEST
	NaturalWonders[GameInfo.Features["FEATURE_KILIMANJARO"].Index] 		 = { X = 45, Y = 36}	
	NaturalWonders[GameInfo.Features["FEATURE_PANTANAL"].Index] 		 = { X = 212, Y = 34}	-- 4 plots, flat grass/plains without features, 1st plot is SOUTH-WEST	
	NaturalWonders[GameInfo.Features["FEATURE_PIOPIOTAHI"].Index] 		 = { X = 143, Y = 4}	-- 3 plots, flat grass near coast, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_TORRES_DEL_PAINE"].Index]  = { X = 205, Y = 8}	-- 2 plots EAST-WEST without features, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_TSINGY"].Index] 			 = { X = 47, Y = 22}	
	NaturalWonders[GameInfo.Features["FEATURE_YOSEMITE"].Index] 		 = { X = 176, Y = 76}	-- 2 plots EAST-WEST, flat tundra/plains without features, 1st plot is WEST
	--]]
	return NaturalWonders
end

function GetCiv6DataToConvert()
	-- Map data is exported from Civ6 WB, cliffs are included in MapToConvert
	return {}
end


function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data (from Civ6 WB)
	-- MapToConvert[x][y] = {civ6TerrainType, civ6FeatureTypes, civ6ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ6ResourceType, num}, {IsNEOfCliff, IsWOfCliff, IsNWOfCliff} }

 MapToConvert[0][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][0]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][0]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][0]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][0]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][0]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][0]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][0]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][0]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][0]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][0]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][0]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][0]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][0]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][0]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][0]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[11][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[12][1]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][1]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][1]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][1]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][1]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][1]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][1]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][1]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[206][1]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][1]={10,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[208][1]={10,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[209][1]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[210][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[219][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][1]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][1]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][2]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][2]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][2]={13,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[10][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[12][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][2]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][2]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][2]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[75][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[76][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[77][2]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[79][2]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[80][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[81][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[82][2]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][2]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[88][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[89][2]={13,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[90][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[91][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][2]={9,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][2]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[146][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][2]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][2]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][2]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][2]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][2]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[207][2]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][2]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[210][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[211][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][2]={12,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[222][2]={13,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[223][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[3][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[4][3]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][3]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][3]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[9][3]={12,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[75][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[79][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[80][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[88][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][3]={9,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][3]={10,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][3]={9,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][3]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][3]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[206][3]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][3]={9,-1,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,1,0}}
 MapToConvert[208][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[222][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[223][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[229][3]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[5][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[132][4]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][4]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][4]={10,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][4]={10,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][4]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][4]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][4]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[206][4]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][4]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[208][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[0][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][5]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][5]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][5]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][5]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][5]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][5]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][5]={4,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[132][5]={4,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][5]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][5]={11,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][5]={11,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][5]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][5]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[147][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[205][5]={9,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][5]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][5]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[208][5]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[209][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[214][5]={9,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[215][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][6]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][6]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][6]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][6]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][6]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][6]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[132][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[133][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][6]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][6]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][6]={0,-1,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[147][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][6]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[206][6]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][6]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][6]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[210][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][6]={3,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][6]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[216][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][7]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][7]={4,-1,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][7]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][7]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][7]={9,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][7]={11,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][7]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][7]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][7]={3,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[33][8]={0,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[34][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][8]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][8]={2,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][8]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][8]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][8]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][8]={11,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][8]={11,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][8]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][8]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][8]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][9]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[32][9]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[33][9]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][9]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][9]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][9]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[37][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[130][9]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[131][9]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[132][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][9]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][9]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[136][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][9]={1,3,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][9]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][9]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[204][9]={9,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][9]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][9]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][9]={4,-1,10,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[208][9]={3,3,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[209][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][10]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][10]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][10]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][10]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][10]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][10]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[38][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][10]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][10]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][10]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][10]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][10]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][10]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][10]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][10]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][10]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][10]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[205][10]={9,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][10]={11,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][10]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][10]={4,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][10]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[210][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][11]={0,-1,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[32][11]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][11]={0,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][11]={4,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][11]={0,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][11]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][11]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][11]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][11]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][11]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][11]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][11]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[117][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][11]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][11]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][11]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][11]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][11]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][11]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][11]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][11]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][11]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][11]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][11]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[204][11]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][11]={11,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][11]={4,3,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][11]={4,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][11]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][11]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[210][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[31][12]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[32][12]={0,-1,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[33][12]={8,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][12]={4,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][12]={1,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][12]={1,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][12]={0,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][12]={2,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][12]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][12]={12,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][12]={0,5,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[115][12]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][12]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][12]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][12]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[126][12]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][12]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][12]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][12]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][12]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][12]={0,3,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][12]={1,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[135][12]={2,-1,36,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][12]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][12]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[138][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[148][12]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[149][12]={1,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][12]={1,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][12]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][12]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][12]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][12]={4,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][12]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][12]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][13]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][13]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][13]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][13]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][13]={0,5,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][13]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][13]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][13]={0,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][13]={1,3,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[39][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][13]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][13]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][13]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][13]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][13]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][13]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][13]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[119][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][13]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][13]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[126][13]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][13]={4,-1,36,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[129][13]={4,-1,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[130][13]={3,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[131][13]={3,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[132][13]={3,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[133][13]={1,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[134][13]={1,-1,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[135][13]={1,-1,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][13]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][13]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[138][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][13]={1,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][13]={0,5,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][13]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][13]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[204][13]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][13]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][13]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][13]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][13]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][13]={3,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][13]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[211][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][14]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][14]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][14]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][14]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][14]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][14]={3,3,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][14]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][14]={5,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][14]={1,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][14]={1,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[40][14]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][14]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][14]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][14]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][14]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][14]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][14]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][14]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[121][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][14]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][14]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][14]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][14]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][14]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][14]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][14]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][14]={7,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[131][14]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][14]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][14]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][14]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][14]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][14]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][14]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][14]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][14]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][14]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[153][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[205][14]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][14]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][14]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][14]={4,3,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][14]={4,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][14]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][15]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][15]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][15]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][15]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][15]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][15]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][15]={3,-1,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][15]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][15]={3,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][15]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][15]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][15]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[113][15]={4,3,36,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[114][15]={0,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[115][15]={4,-1,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][15]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[121][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][15]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][15]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][15]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][15]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][15]={7,-1,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[131][15]={7,-1,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[132][15]={7,-1,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[133][15]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][15]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][15]={1,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][15]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][15]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][15]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][15]={1,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][15]={1,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[205][15]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][15]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][15]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][15]={4,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][15]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][15]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][15]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][15]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[213][15]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][16]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][16]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][16]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][16]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][16]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][16]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][16]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][16]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][16]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][16]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][16]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][16]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[42][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[113][16]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[114][16]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][16]={6,4,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][16]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][16]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][16]={6,4,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][16]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][16]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][16]={15,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][16]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][16]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][16]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][16]={3,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[134][16]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][16]={1,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][16]={1,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][16]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][16]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][16]={0,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[149][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][16]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][16]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][16]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][16]={4,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][16]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][16]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][16]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][16]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][16]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][17]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][17]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][17]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][17]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][17]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][17]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][17]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][17]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][17]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][17]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][17]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][17]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][17]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][17]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][17]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][17]={1,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[48][17]={1,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[49][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][17]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][17]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][17]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][17]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][17]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][17]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][17]={6,4,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][17]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][17]={15,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][17]={6,0,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][17]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][17]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][17]={6,0,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[134][17]={1,-1,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[135][17]={1,-1,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[136][17]={1,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][17]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][17]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[147][17]={0,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[149][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[204][17]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][17]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][17]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][17]={4,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][17]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][17]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][17]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][17]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][17]={4,3,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][17]={3,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[28][18]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[29][18]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][18]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][18]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][18]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][18]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][18]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][18]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][18]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][18]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][18]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][18]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][18]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][18]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][18]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][18]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][18]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][18]={1,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][18]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][18]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][18]={6,0,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[131][18]={6,0,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][18]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][18]={3,3,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[135][18]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][18]={1,3,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[137][18]={2,-1,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][18]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[205][18]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][18]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][18]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][18]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][18]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][18]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][18]={3,3,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][18]={3,3,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[213][18]={3,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][18]={0,5,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][19]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[28][19]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][19]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][19]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][19]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][19]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][19]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][19]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][19]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][19]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][19]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][19]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][19]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][19]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][19]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[46][19]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][19]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][19]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][19]={1,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[111][19]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][19]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][19]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][19]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][19]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][19]={7,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[131][19]={6,0,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][19]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][19]={3,3,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[135][19]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][19]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][19]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][19]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[139][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][19]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][19]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][19]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][19]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][19]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][19]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][19]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][19]={3,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][19]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][19]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][19]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][19]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[216][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][20]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][20]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][20]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][20]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][20]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][20]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][20]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][20]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][20]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][20]={4,2,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[37][20]={3,2,9,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][20]={3,2,9,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[39][20]={3,-1,9,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][20]={3,3,9,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][20]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[42][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[43][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][20]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][20]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][20]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][20]={1,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][20]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[63][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][20]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][20]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][20]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][20]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][20]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][20]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][20]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][20]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][20]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][20]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][20]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][20]={0,-1,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[136][20]={0,5,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][20]={1,2,36,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[138][20]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[139][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][20]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][20]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][20]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][20]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][20]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][20]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][20]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][20]={1,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][20]={0,5,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][20]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][20]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][20]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[217][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][21]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][21]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][21]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][21]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][21]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][21]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][21]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][21]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][21]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][21]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][21]={4,2,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][21]={3,2,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][21]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][21]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][21]={3,-1,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][21]={3,3,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][21]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[48][21]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[49][21]={0,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][21]={1,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[51][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][21]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][21]={0,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][21]={3,-1,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[112][21]={3,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[113][21]={3,-1,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[114][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][21]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][21]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][21]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][21]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][21]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][21]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][21]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][21]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][21]={0,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][21]={1,2,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[138][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[139][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[178][21]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][21]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[180][21]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][21]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][21]={7,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][21]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][21]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][21]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][21]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][21]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][21]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][21]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][21]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][21]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][21]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][21]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][22]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[27][22]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][22]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][22]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][22]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][22]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][22]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][22]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][22]={3,3,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][22]={4,3,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][22]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][22]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][22]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][22]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][22]={0,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[52][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[112][22]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][22]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][22]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][22]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][22]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][22]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][22]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][22]={6,4,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][22]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][22]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][22]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][22]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][22]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][22]={0,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[179][22]={0,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][22]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][22]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][22]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][22]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][22]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][22]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][22]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][22]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][22]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][22]={15,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][22]={0,3,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][22]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][22]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][22]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[219][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][23]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][23]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][23]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][23]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][23]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][23]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][23]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][23]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][23]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][23]={3,2,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][23]={3,-1,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][23]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][23]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][23]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][23]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][23]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][23]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][23]={3,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][23]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][23]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][23]={0,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[112][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][23]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][23]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][23]={6,4,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][23]={7,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][23]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][23]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][23]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][23]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][23]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][23]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[144][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][23]={3,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[205][23]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][23]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][23]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][23]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][23]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][23]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][23]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][23]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][23]={0,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][23]={0,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][23]={0,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][23]={0,3,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][23]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][23]={1,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[219][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][24]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][24]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][24]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][24]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][24]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][24]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][24]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][24]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][24]={3,-1,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][24]={3,3,9,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[36][24]={3,-1,9,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][24]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][24]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][24]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][24]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][24]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][24]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[47][24]={3,-1,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[48][24]={3,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][24]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][24]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][24]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][24]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][24]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][24]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][24]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][24]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][24]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][24]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][24]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][24]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][24]={3,2,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[136][24]={3,2,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[137][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[138][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][24]={0,5,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[144][24]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[145][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][24]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][24]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][24]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][24]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][24]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][24]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][24]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][24]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][24]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][24]={0,3,10,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[215][24]={3,3,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[216][24]={0,-1,10,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[217][24]={1,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][24]={1,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][24]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][24]={1,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[221][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][25]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][25]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][25]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][25]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][25]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][25]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][25]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][25]={4,-1,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][25]={3,3,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][25]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][25]={3,3,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][25]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][25]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][25]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][25]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][25]={4,3,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][25]={3,-1,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][25]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[44][25]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[45][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[47][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[48][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][25]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][25]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][25]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][25]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[115][25]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][25]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][25]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][25]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][25]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][25]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][25]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][25]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][25]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][25]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][25]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][25]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][25]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][25]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][25]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][25]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][25]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][25]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][25]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][25]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][25]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[136][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][25]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][25]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][25]={7,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][25]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][25]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][25]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][25]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][25]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][25]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][25]={1,3,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][25]={0,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][25]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][25]={3,-1,10,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[217][25]={4,3,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[218][25]={0,-1,10,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[219][25]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][25]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[221][25]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[222][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][26]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][26]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][26]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][26]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][26]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][26]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][26]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][26]={4,-1,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][26]={3,-1,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][26]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][26]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][26]={3,3,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[38][26]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[39][26]={4,-1,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[40][26]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][26]={4,-1,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][26]={3,-1,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][26]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][26]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][26]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][26]={4,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][26]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][26]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][26]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][26]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][26]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][26]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][26]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][26]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][26]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][26]={3,2,36,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[126][26]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][26]={0,2,36,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[128][26]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][26]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][26]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][26]={3,3,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][26]={3,-1,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[133][26]={3,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[136][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[137][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][26]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][26]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][26]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][26]={8,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][26]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][26]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][26]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][26]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][26]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][26]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][26]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][26]={0,-1,10,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[215][26]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][26]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][26]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][26]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][26]={2,-1,10,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[220][26]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][26]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][26]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[26][27]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][27]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][27]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][27]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][27]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][27]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][27]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][27]={4,3,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][27]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][27]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][27]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][27]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][27]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][27]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][27]={4,-1,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][27]={4,-1,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][27]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][27]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][27]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][27]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[52][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][27]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][27]={3,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][27]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][27]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][27]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][27]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][27]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][27]={3,2,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[126][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[129][27]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][27]={3,3,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[131][27]={4,-1,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][27]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][27]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[204][27]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[205][27]={6,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][27]={8,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][27]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][27]={15,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[209][27]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][27]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][27]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][27]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][27]={1,3,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][27]={0,3,10,{{1,2},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[215][27]={0,-1,10,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[216][27]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][27]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][27]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][27]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][27]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][27]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][27]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][27]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][28]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][28]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][28]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][28]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][28]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][28]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][28]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][28]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][28]={4,2,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][28]={3,2,9,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][28]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][28]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][28]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][28]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][28]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][28]={4,-1,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][28]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][28]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][28]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[52][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[53][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[118][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[119][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[121][28]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][28]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][28]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][28]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][28]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[126][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[127][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][28]={3,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][28]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][28]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[134][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][28]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][28]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][28]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[164][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[203][28]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[204][28]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][28]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][28]={8,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][28]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][28]={0,5,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][28]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[210][28]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][28]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][28]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][28]={3,2,10,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[215][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][28]={3,2,10,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[217][28]={3,2,10,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[218][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][28]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][28]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][29]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][29]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][29]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][29]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][29]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][29]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][29]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][29]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][29]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][29]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][29]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][29]={3,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][29]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][29]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][29]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][29]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][29]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][29]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][29]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][29]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[105][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][29]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][29]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][29]={3,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][29]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][29]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][29]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[126][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][29]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][29]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[132][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[133][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][29]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[155][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][29]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][29]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[164][29]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[165][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][29]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][29]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][29]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][29]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][29]={0,5,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][29]={15,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[209][29]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][29]={10,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][29]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][29]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][29]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][29]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][29]={4,2,10,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[218][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][29]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][29]={0,5,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][29]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][30]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[27][30]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][30]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][30]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][30]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][30]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][30]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][30]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][30]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][30]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][30]={0,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][30]={3,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][30]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][30]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][30]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][30]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][30]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][30]={4,2,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][30]={4,2,9,{{1,2},{0,-1},{1,1}},{-1,1},{0,1,0}}
 MapToConvert[45][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[46][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][30]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][30]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][30]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[113][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][30]={4,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][30]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][30]={4,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[127][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[130][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[131][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[145][30]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[146][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][30]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][30]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][30]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][30]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][30]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][30]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][30]={15,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[209][30]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[210][30]={10,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][30]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][30]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][30]={3,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][30]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][30]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][30]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][30]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][30]={0,-1,10,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[219][30]={3,2,10,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[220][30]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][30]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][30]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][30]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][30]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][30]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[226][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][31]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][31]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][31]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][31]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][31]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][31]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][31]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][31]={4,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[40][31]={4,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][31]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[42][31]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[43][31]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][31]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][31]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[107][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][31]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][31]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][31]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[112][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][31]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[119][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[122][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[123][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[124][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[127][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][31]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][31]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][31]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][31]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][31]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][31]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][31]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][31]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][31]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][31]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][31]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][31]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[209][31]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][31]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][31]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][31]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][31]={3,2,10,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[214][31]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][31]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][31]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][31]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][31]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][31]={3,2,10,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[220][31]={3,-1,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[221][31]={3,2,10,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[222][31]={4,2,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[223][31]={5,-1,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[224][31]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][31]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[226][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][32]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][32]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][32]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][32]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][32]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][32]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][32]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][32]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][32]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][32]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][32]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][32]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][32]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][32]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][32]={4,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][32]={2,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][32]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][32]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][32]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][32]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[45][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][32]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][32]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][32]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][32]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][32]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][32]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][32]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[132][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][32]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[202][32]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[203][32]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][32]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][32]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][32]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][32]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][32]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][32]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][32]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][32]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][32]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][32]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][32]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][32]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][32]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][32]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][32]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][32]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][32]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][32]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][32]={1,-1,10,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[223][32]={4,2,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[224][32]={5,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][32]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][32]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][33]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][33]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[26][33]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[27][33]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][33]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][33]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][33]={4,2,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][33]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][33]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][33]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][33]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][33]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][33]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][33]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][33]={4,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[39][33]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][33]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][33]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][33]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][33]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][33]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[45][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][33]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][33]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][33]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[102][33]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][33]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][33]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[105][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][33]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][33]={3,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[109][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][33]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][33]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][33]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][33]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][33]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][33]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][33]={10,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][33]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][33]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][33]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][33]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][33]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][33]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][33]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][33]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][33]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][33]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][33]={4,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][33]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][33]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][33]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[25][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][34]={3,2,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][34]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][34]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][34]={3,2,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][34]={3,-1,9,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][34]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][34]={0,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][34]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][34]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][34]={4,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][34]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[40][34]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[41][34]={2,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][34]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][34]={0,5,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][34]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[63][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[64][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][34]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[102][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[108][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[111][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[121][34]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][34]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[201][34]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][34]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][34]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][34]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][34]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][34]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][34]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][34]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][34]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][34]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][34]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][34]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][34]={3,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][34]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[215][34]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][34]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][34]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][34]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][34]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][34]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][34]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][34]={4,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[223][34]={4,2,10,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[224][34]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][34]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][34]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][34]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][35]={0,5,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][35]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][35]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][35]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][35]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][35]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][35]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][35]={3,2,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][35]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][35]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][35]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][35]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][35]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][35]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][35]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[40][35]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][35]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][35]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][35]={3,2,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][35]={3,-1,9,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[45][35]={3,2,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][35]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[101][35]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][35]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][35]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[112][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][35]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][35]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[132][35]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[133][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][35]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][35]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[137][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[200][35]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[201][35]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][35]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][35]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][35]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][35]={5,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[206][35]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][35]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[208][35]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][35]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][35]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][35]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][35]={3,2,10,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[213][35]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][35]={4,2,10,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][35]={4,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][35]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][35]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[218][35]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][35]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[220][35]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][35]={3,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][35]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][35]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[224][35]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][35]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][35]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][35]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][35]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][36]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][36]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][36]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][36]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][36]={3,2,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][36]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][36]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][36]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][36]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][36]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[41][36]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][36]={15,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[43][36]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][36]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][36]={8,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][36]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[47][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][36]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][36]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][36]={2,-1,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][36]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[106][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][36]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][36]={3,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[112][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][36]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[114][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][36]={4,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][36]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][36]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][36]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][36]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][36]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][36]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][36]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][36]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[199][36]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][36]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][36]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][36]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][36]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][36]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][36]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][36]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][36]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][36]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][36]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][36]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][36]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][36]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][36]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][36]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[215][36]={4,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][36]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][36]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][36]={4,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][36]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][36]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][36]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][36]={4,-1,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[223][36]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[224][36]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[225][36]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][36]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][36]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][36]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[229][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[0][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[25][37]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[26][37]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[27][37]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][37]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][37]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][37]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][37]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][37]={3,2,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][37]={3,-1,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][37]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][37]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][37]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][37]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[38][37]={4,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[39][37]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][37]={4,2,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][37]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[42][37]={5,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[43][37]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][37]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][37]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][37]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][37]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[79][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[95][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][37]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][37]={4,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][37]={3,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][37]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][37]={4,2,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[112][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][37]={4,-1,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[118][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[119][37]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][37]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][37]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][37]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][37]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][37]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][37]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][37]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][37]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][37]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][37]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][37]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[199][37]={4,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][37]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][37]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][37]={5,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][37]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][37]={5,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][37]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][37]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][37]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][37]={4,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[211][37]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[212][37]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][37]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][37]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][37]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[218][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][37]={0,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[220][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][37]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][37]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][37]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[225][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][37]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][37]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][37]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[229][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][38]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][38]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][38]={3,-1,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][38]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][38]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[30][38]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][38]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][38]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][38]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][38]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][38]={3,2,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][38]={3,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][38]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][38]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][38]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][38]={4,2,9,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][38]={4,-1,9,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][38]={2,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][38]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][38]={2,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][38]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][38]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][38]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][38]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[49][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[96][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[98][38]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][38]={0,5,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[108][38]={3,2,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[109][38]={3,2,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[110][38]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][38]={4,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][38]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][38]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[118][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][38]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[125][38]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][38]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][38]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][38]={4,2,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[129][38]={4,-1,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[130][38]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][38]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][38]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[133][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[134][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][38]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][38]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][38]={3,2,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[152][38]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[153][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][38]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][38]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][38]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][38]={4,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[202][38]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][38]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][38]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][38]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][38]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][38]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][38]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][38]={4,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][38]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][38]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][38]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[213][38]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][38]={3,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[215][38]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][38]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][38]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][38]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[219][38]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][38]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[221][38]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][38]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][38]={3,-1,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[224][38]={3,-1,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[225][38]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[226][38]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][38]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][38]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][39]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][39]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][39]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][39]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][39]={4,2,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[30][39]={4,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[31][39]={3,2,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[32][39]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][39]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][39]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][39]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][39]={3,-1,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][39]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][39]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][39]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][39]={4,2,9,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[41][39]={2,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][39]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][39]={5,-1,-1,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][39]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][39]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][39]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][39]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][39]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][39]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[50][39]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[51][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][39]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][39]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][39]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[85][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[97][39]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[98][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][39]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[103][39]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[104][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][39]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][39]={3,2,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[110][39]={3,2,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[111][39]={4,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[112][39]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][39]={2,-1,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[117][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[118][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][39]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][39]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[125][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][39]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][39]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][39]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][39]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][39]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][39]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[198][39]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][39]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][39]={3,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][39]={4,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][39]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[203][39]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][39]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[205][39]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][39]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][39]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][39]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][39]={4,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[210][39]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[211][39]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[212][39]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[213][39]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[214][39]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[215][39]={3,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[216][39]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][39]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][39]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[219][39]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][39]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[221][39]={0,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][39]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][39]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][39]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][39]={3,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[226][39]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][40]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[11][40]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[12][40]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][40]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][40]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][40]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][40]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][40]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][40]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][40]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][40]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][40]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][40]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][40]={0,5,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][40]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][40]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][40]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][40]={1,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][40]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][40]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][40]={4,2,9,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][40]={4,2,9,{{1,5},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][40]={3,2,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][40]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][40]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][40]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][40]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][40]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][40]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][40]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][40]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][40]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][40]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][40]={5,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][40]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[86][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][40]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][40]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][40]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][40]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[104][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[109][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][40]={4,2,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[112][40]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][40]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][40]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][40]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][40]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[119][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[126][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][40]={4,2,36,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[128][40]={4,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][40]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[133][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[134][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][40]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[139][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[199][40]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][40]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][40]={5,-1,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[202][40]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[203][40]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[204][40]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[205][40]={3,2,10,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[206][40]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[207][40]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][40]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][40]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[216][40]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[217][40]={0,5,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[218][40]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][40]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[220][40]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][40]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][40]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][40]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][40]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[225][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][41]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][41]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][41]={3,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[15][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[16][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[17][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][41]={3,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][41]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][41]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][41]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][41]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][41]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][41]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][41]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][41]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][41]={1,-1,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][41]={4,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][41]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][41]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][41]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][41]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][41]={8,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][41]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][41]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][41]={6,4,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][41]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][41]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][41]={4,2,33,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][41]={4,2,33,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][41]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][41]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][41]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][41]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][41]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][41]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][41]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][41]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[104][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[109][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[110][41]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][41]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][41]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][41]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][41]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][41]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[126][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][41]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[128][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[129][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[131][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][41]={4,3,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[200][41]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][41]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][41]={0,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][41]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[204][41]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[205][41]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][41]={0,-1,10,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[207][41]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[208][41]={3,-1,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[209][41]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[210][41]={3,2,10,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[211][41]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[212][41]={3,-1,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[213][41]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[214][41]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][41]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[216][41]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[217][41]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[218][41]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][41]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[220][41]={3,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[221][41]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][41]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[225][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][42]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[10][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][42]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][42]={3,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][42]={3,2,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][42]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][42]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][42]={0,5,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][42]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[23][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[24][42]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[25][42]={3,2,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][42]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][42]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][42]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][42]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][42]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][42]={4,2,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][42]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][42]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][42]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][42]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][42]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][42]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][42]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][42]={4,-1,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][42]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][42]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][42]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][42]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][42]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][42]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][42]={8,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][42]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][42]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][42]={8,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][42]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][42]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][42]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[54][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[80][42]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[81][42]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][42]={3,2,33,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][42]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][42]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][42]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][42]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][42]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][42]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][42]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][42]={4,2,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[103][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[111][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[112][42]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][42]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][42]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][42]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][42]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][42]={2,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][42]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[203][42]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][42]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][42]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][42]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[207][42]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][42]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][42]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][42]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][42]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][42]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][42]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][42]={3,2,10,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[215][42]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[216][42]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[217][42]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[218][42]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][42]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][42]={3,2,10,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][42]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][42]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][43]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[10][43]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][43]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][43]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[14][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][43]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][43]={4,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][43]={3,2,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][43]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][43]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[25][43]={3,-1,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][43]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][43]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][43]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][43]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][43]={3,2,9,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][43]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][43]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][43]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][43]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][43]={3,2,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][43]={3,-1,9,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[39][43]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][43]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][43]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][43]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][43]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][43]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][43]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][43]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][43]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][43]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][43]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][43]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][43]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][43]={7,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][43]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[54][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][43]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][43]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][43]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][43]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[83][43]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][43]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][43]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][43]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][43]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][43]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][43]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][43]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][43]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][43]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][43]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][43]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][43]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][43]={4,2,10,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[201][43]={2,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][43]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][43]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[205][43]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][43]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][43]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[209][43]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[210][43]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][43]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][43]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][43]={3,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[217][43]={0,5,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[218][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][43]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[220][43]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][43]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[8][44]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[9][44]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][44]={4,2,34,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[11][44]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][44]={3,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][44]={3,2,34,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[14][44]={3,2,34,{{1,2},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][44]={3,2,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][44]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][44]={3,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][44]={3,2,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][44]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][44]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][44]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][44]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][44]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][44]={3,2,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][44]={4,2,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][44]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][44]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][44]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][44]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][44]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][44]={3,-1,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][44]={3,2,34,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][44]={3,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][44]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][44]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][44]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][44]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][44]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][44]={3,-1,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][44]={3,2,9,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][44]={3,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][44]={4,2,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][44]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][44]={5,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][44]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][44]={4,2,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][44]={4,2,9,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[48][44]={4,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][44]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[50][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[51][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[52][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[53][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[54][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[55][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][44]={3,2,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][44]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][44]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][44]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][44]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[85][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][44]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][44]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][44]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[102][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[103][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[113][44]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[114][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][44]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][44]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][44]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[144][44]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[145][44]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][44]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][44]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][44]={4,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[201][44]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][44]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][44]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][44]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][44]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][44]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][44]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[208][44]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][44]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][44]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][44]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][44]={3,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][44]={3,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[214][44]={3,2,10,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[215][44]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][44]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][44]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][44]={3,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[219][44]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][45]={0,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][45]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][45]={4,-1,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][45]={4,2,34,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][45]={3,2,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][45]={3,3,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[15][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][45]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[18][45]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][45]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][45]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][45]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][45]={3,3,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[25][45]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][45]={4,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][45]={5,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][45]={5,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][45]={4,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][45]={3,-1,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][45]={3,3,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[32][45]={3,-1,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][45]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][45]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][45]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][45]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][45]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][45]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][45]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][45]={3,-1,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][45]={3,3,9,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][45]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][45]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][45]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][45]={3,3,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][45]={5,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][45]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][45]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][45]={0,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][45]={1,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][45]={1,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][45]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][45]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[83][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][45]={3,-1,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[99][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[113][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[114][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][45]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][45]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][45]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][45]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][45]={0,3,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][45]={1,3,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[145][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[198][45]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][45]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][45]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][45]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][45]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][45]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][45]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][45]={4,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][45]={4,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][45]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][45]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][45]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][45]={2,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][45]={3,-1,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[212][45]={3,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][45]={0,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][45]={1,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][45]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][45]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][45]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][45]={0,3,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[219][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][46]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][46]={4,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][46]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][46]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][46]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][46]={4,-1,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[13][46]={3,2,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[14][46]={3,2,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][46]={3,2,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][46]={3,3,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][46]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][46]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][46]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][46]={3,3,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][46]={3,3,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][46]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][46]={5,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][46]={4,-1,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][46]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][46]={3,3,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][46]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][46]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][46]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][46]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][46]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][46]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][46]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][46]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][46]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][46]={3,3,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][46]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][46]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][46]={4,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][46]={5,-1,9,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][46]={4,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][46]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[51][46]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[52][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][46]={1,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][46]={2,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][46]={2,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][46]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][46]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[84][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][46]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][46]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][46]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[104][46]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][46]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[120][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[121][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[146][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][46]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][46]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][46]={1,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][46]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][46]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][46]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][46]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][46]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][46]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][46]={4,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][46]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][46]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][46]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][46]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][46]={4,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][46]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][46]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][46]={3,2,10,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[215][46]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][46]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][46]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][46]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][46]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[220][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][47]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][47]={4,2,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][47]={4,3,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][47]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][47]={3,-1,34,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][47]={3,3,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][47]={3,2,34,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[14][47]={3,2,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][47]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][47]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][47]={3,-1,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][47]={4,-1,34,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[23][47]={3,3,34,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[24][47]={3,3,34,{{1,2},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[25][47]={3,3,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[26][47]={3,3,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[27][47]={4,3,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][47]={3,-1,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][47]={15,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][47]={3,-1,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][47]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][47]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][47]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][47]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][47]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][47]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][47]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][47]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][47]={3,-1,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][47]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][47]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][47]={3,3,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][47]={3,-1,9,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[47][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][47]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][47]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][47]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][47]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][47]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[54][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[77][47]={0,2,33,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[78][47]={1,2,33,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[79][47]={2,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][47]={1,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][47]={4,-1,33,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][47]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][47]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][47]={0,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][47]={0,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][47]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][47]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][47]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[119][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][47]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[122][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][47]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[199][47]={1,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][47]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][47]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][47]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][47]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][47]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][47]={5,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][47]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][47]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][47]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][47]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][47]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][47]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][47]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][47]={2,-1,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][47]={3,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][47]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][47]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][47]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][47]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[220][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][48]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][48]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][48]={3,2,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][48]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][48]={3,-1,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][48]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][48]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][48]={3,3,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][48]={3,-1,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][48]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][48]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][48]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][48]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][48]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][48]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][48]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][48]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][48]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][48]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][48]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][48]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][48]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][48]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][48]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][48]={3,3,9,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][48]={3,-1,9,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[45][48]={6,0,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][48]={3,3,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][48]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][48]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][48]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][48]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][48]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][48]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[56][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][48]={0,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][48]={0,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][48]={1,3,33,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[80][48]={4,-1,33,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][48]={5,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][48]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[92][48]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][48]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][48]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[101][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][48]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][48]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][48]={0,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][48]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][48]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][48]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[123][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][48]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][48]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[200][48]={1,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[201][48]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][48]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][48]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][48]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][48]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][48]={4,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[207][48]={3,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[208][48]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][48]={3,2,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][48]={3,-1,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[211][48]={0,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][48]={0,5,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][48]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][48]={2,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][48]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][48]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][48]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[219][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][49]={1,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[1][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[6][49]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][49]={3,2,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][49]={3,-1,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][49]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][49]={7,-1,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][49]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][49]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][49]={3,3,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][49]={3,-1,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][49]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][49]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][49]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][49]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][49]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][49]={3,3,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][49]={3,3,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][49]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][49]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[49][49]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][49]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][49]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][49]={6,4,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][49]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][49]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][49]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][49]={0,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][49]={0,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][49]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][49]={4,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][49]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][49]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[97][49]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][49]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][49]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][49]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][49]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][49]={3,2,36,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[104][49]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][49]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[106][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][49]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][49]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][49]={1,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[201][49]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][49]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][49]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][49]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][49]={3,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][49]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][49]={3,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[208][49]={3,-1,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[209][49]={3,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][49]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][49]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][49]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][49]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][49]={0,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[215][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][50]={1,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][50]={3,3,34,{{1,5},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[8][50]={3,3,34,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][50]={6,0,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][50]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][50]={3,-1,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][50]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][50]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][50]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][50]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][50]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][50]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][50]={3,3,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][50]={6,0,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][50]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][50]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][50]={3,-1,9,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][50]={3,-1,9,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][50]={3,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][50]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[47][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][50]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[50][50]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][50]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][50]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][50]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][50]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][50]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[58][50]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[59][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][50]={0,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][50]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][50]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][50]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][50]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][50]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[94][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[98][50]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][50]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][50]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][50]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][50]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][50]={3,2,36,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][50]={3,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][50]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][50]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[107][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][50]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][50]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][50]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][50]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[202][50]={5,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][50]={4,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[204][50]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][50]={3,-1,10,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][50]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][50]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][50]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][50]={4,2,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[210][50]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][50]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][50]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][50]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][50]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[216][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][51]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][51]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][51]={6,0,34,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][51]={3,3,34,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[13][51]={6,0,34,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[14][51]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][51]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][51]={7,-1,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][51]={6,0,34,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[20][51]={6,0,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][51]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][51]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][51]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][51]={3,3,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][51]={6,0,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][51]={6,-1,9,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[45][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][51]={4,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][51]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][51]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][51]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][51]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][51]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][51]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][51]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][51]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][51]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][51]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][51]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][51]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[76][51]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[77][51]={0,5,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][51]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][51]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][51]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][51]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][51]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[94][51]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[95][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][51]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][51]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][51]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][51]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][51]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][51]={3,3,36,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][51]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][51]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][51]={4,2,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[106][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][51]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][51]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][51]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[200][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][51]={4,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][51]={4,3,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[203][51]={4,3,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][51]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][51]={4,-1,10,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[206][51]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][51]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][51]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][51]={1,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[210][51]={1,2,10,{{1,2},{0,-1},{1,1}},{-1,1},{0,1,0}}
 MapToConvert[211][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][51]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][52]={6,0,34,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][52]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][52]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][52]={7,-1,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][52]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][52]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][52]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][52]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][52]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][52]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][52]={3,3,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][52]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][52]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][52]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][52]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][52]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][52]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][52]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][52]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][52]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][52]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][52]={6,4,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][52]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][52]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][52]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[75][52]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][52]={1,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][52]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][52]={3,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][52]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][52]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][52]={3,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][52]={4,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][52]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][52]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][52]={4,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][52]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][52]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][52]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][52]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][52]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][52]={3,3,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][52]={4,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][52]={4,3,36,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[105][52]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][52]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][52]={3,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][52]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][52]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[197][52]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][52]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[199][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[202][52]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[204][52]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[207][52]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][52]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][52]={1,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[210][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[212][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][53]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][53]={6,0,34,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][53]={6,0,34,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[16][53]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][53]={6,0,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][53]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][53]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][53]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][53]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][53]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][53]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][53]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][53]={6,0,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][53]={6,0,34,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][53]={6,0,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][53]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][53]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][53]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][53]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][53]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][53]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][53]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][53]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][53]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[62][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[74][53]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[75][53]={1,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][53]={1,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][53]={4,2,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][53]={4,3,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][53]={3,-1,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[81][53]={4,-1,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][53]={3,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][53]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[84][53]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[93][53]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][53]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][53]={1,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][53]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][53]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][53]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][53]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][53]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][53]={3,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][53]={3,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][53]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[104][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[105][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][53]={1,2,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][53]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][53]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][53]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[195][53]={0,3,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][53]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[197][53]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][53]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[199][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[204][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[207][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][54]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][54]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][54]={6,0,34,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[17][54]={6,0,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[18][54]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][54]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][54]={6,0,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][54]={6,0,34,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[43][54]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][54]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][54]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][54]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][54]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][54]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][54]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][54]={6,4,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][54]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][54]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][54]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][54]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][54]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][54]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[75][54]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][54]={1,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][54]={4,-1,33,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[78][54]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][54]={3,-1,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[80][54]={4,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][54]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][54]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][54]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][54]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][54]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[94][54]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][54]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][54]={1,2,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[97][54]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][54]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][54]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][54]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][54]={4,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][54]={3,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][54]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[105][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[116][54]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][54]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][54]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[133][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][54]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][54]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[196][54]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][54]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][54]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][54]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][54]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[216][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][55]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[6][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][55]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][55]={6,0,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][55]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][55]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][55]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][55]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][55]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][55]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][55]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][55]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][55]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[59][55]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][55]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][55]={4,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][55]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][55]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][55]={4,-1,33,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[78][55]={4,-1,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[79][55]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][55]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][55]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][55]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][55]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][55]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][55]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][55]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][55]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[88][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][55]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][55]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][55]={0,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][55]={0,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][55]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][55]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][55]={4,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][55]={4,-1,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[101][55]={4,3,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][55]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][55]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[106][55]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[107][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[116][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[193][55]={0,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][55]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][55]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][55]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][55]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][55]={0,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][55]={3,-1,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][56]={0,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[4][56]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][56]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][56]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][56]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][56]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][56]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][56]={6,0,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][56]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[47][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][56]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][56]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][56]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][56]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][56]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][56]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[55][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[56][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[57][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[60][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][56]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][56]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][56]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][56]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][56]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][56]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][56]={4,3,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[80][56]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][56]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][56]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][56]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][56]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][56]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][56]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][56]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][56]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[89][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][56]={4,2,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[94][56]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][56]={4,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][56]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][56]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][56]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][56]={4,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][56]={4,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][56]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][56]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][56]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][56]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][56]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][56]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[191][56]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[192][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][56]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][56]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][56]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][56]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][56]={1,2,10,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[198][56]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[4][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[6][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][57]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][57]={6,0,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][57]={6,0,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][57]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][57]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][57]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][57]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][57]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][57]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][57]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][57]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][57]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[62][57]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[63][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[64][57]={3,-1,33,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[67][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][57]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][57]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][57]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][57]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][57]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][57]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][57]={4,-1,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[80][57]={3,-1,36,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[81][57]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][57]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][57]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][57]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][57]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][57]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][57]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][57]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[89][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][57]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][57]={1,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[94][57]={0,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][57]={0,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][57]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][57]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][57]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][57]={4,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[100][57]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][57]={4,2,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[102][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][57]={3,2,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][57]={3,-1,36,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][57]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[186][57]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[187][57]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[188][57]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[189][57]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][57]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][57]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][57]={2,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][57]={1,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][57]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][57]={3,2,10,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[198][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][57]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[207][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][57]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[212][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][57]={0,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][58]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][58]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][58]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][58]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][58]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][58]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][58]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][58]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][58]={6,0,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][58]={6,0,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][58]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][58]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][58]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][58]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][58]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][58]={3,-1,33,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][58]={3,3,33,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][58]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[69][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][58]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][58]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][58]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][58]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][58]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][58]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][58]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][58]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][58]={4,-1,36,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[82][58]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][58]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][58]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][58]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][58]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][58]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][58]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][58]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[90][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][58]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][58]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][58]={4,-1,36,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[96][58]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][58]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][58]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][58]={3,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][58]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][58]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][58]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[103][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[185][58]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[186][58]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[187][58]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][58]={4,2,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[189][58]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][58]={4,-1,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[194][58]={1,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[198][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[203][58]={3,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][58]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][58]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][58]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][58]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][58]={1,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][58]={2,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][58]={4,2,10,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][58]={4,-1,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[213][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][58]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][58]={1,2,10,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[216][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][59]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][59]={6,0,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][59]={6,0,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[9][59]={8,-1,34,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[10][59]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][59]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][59]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][59]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][59]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][59]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][59]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][59]={6,0,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][59]={6,0,34,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][59]={6,0,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[43][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[44][59]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][59]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[54][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[55][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][59]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][59]={3,-1,33,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[65][59]={5,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][59]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[71][59]={6,0,33,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[72][59]={6,0,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][59]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][59]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][59]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][59]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][59]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][59]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][59]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][59]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][59]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][59]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][59]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][59]={3,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][59]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][59]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][59]={0,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][59]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][59]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][59]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][59]={0,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][59]={2,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][59]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][59]={2,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][59]={4,-1,36,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[99][59]={4,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][59]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][59]={1,-1,36,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[102][59]={3,2,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][59]={0,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][59]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[115][59]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[116][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][59]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[158][59]={1,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][59]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][59]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][59]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[185][59]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][59]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][59]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][59]={4,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[189][59]={4,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][59]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[191][59]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[192][59]={3,2,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][59]={4,2,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][59]={1,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[196][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][59]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][59]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[202][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[203][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][59]={3,2,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[205][59]={3,2,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[206][59]={4,-1,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[207][59]={1,2,10,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[208][59]={1,2,10,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[209][59]={0,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[210][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][59]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][59]={4,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[213][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][60]={3,-1,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][60]={3,3,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][60]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][60]={8,-1,34,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][60]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][60]={8,-1,34,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[13][60]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][60]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][60]={6,4,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][60]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][60]={4,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][60]={4,3,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[29][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[33][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][60]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][60]={3,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][60]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][60]={4,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][60]={0,5,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][60]={0,-1,34,{{1,2},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][60]={0,-1,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][60]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][60]={6,0,34,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][60]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][60]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][60]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][60]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][60]={7,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[57][60]={3,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[58][60]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][60]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][60]={4,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][60]={5,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][60]={5,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][60]={5,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][60]={3,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][60]={4,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][60]={4,3,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][60]={4,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][60]={6,4,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][60]={6,0,33,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[73][60]={6,0,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][60]={6,-1,33,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][60]={6,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][60]={3,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][60]={0,5,36,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][60]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][60]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][60]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][60]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][60]={4,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][60]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][60]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][60]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][60]={0,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][60]={0,5,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][60]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][60]={0,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][60]={4,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][60]={4,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][60]={2,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][60]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][60]={2,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][60]={1,-1,36,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][60]={2,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][60]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][60]={1,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][60]={1,2,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][60]={3,2,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[106][60]={0,5,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][60]={3,-1,36,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][60]={0,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[111][60]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][60]={4,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][60]={5,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][60]={1,3,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][60]={1,-1,36,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[146][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[147][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[158][60]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[159][60]={5,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[160][60]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][60]={0,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[180][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[181][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[182][60]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[183][60]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[184][60]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[185][60]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[186][60]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[187][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[188][60]={0,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[189][60]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[190][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[191][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[192][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[193][60]={0,2,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[194][60]={3,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[195][60]={0,2,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[196][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[197][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[198][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[199][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[200][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[201][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[202][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[203][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[204][60]={4,2,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[205][60]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[206][60]={3,-1,10,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[207][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[208][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[209][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[210][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[211][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[212][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[213][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[214][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[215][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[216][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[217][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[218][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[219][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[220][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[221][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[222][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[223][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[224][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[225][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[226][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[227][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[228][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[229][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[7][61]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][61]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][61]={4,-1,34,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][61]={4,-1,34,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[11][61]={3,-1,34,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][61]={3,-1,34,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[13][61]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][61]={7,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][61]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][61]={8,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][61]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][61]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][61]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][61]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][61]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][61]={6,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][61]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][61]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][61]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][61]={3,-1,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][61]={4,3,34,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][61]={3,-1,34,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[29][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[30][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{